/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore.maploader;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.lang.ref.WeakReference;

public class NetworkState {
    private boolean isNetReceiverRegistered = false;
    private NetworkChangeListener mNetworkListener;
    private MyBroadcastReceiver netChangeReceiver = null;

    public void setNetworkListener(NetworkChangeListener networkChangeListener) {
        this.mNetworkListener = networkChangeListener;
    }

    public void registerNetChangeReceiver(Context context, boolean bl2) {
        if (bl2) {
            if (!this.isNetReceiverRegistered) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                if (this.netChangeReceiver == null) {
                    this.netChangeReceiver = new MyBroadcastReceiver(this.mNetworkListener);
                }
                context.registerReceiver((BroadcastReceiver)this.netChangeReceiver, intentFilter);
            }
        } else if (this.isNetReceiverRegistered && this.netChangeReceiver != null) {
            context.unregisterReceiver((BroadcastReceiver)this.netChangeReceiver);
            this.netChangeReceiver = null;
        }
        this.isNetReceiverRegistered = bl2;
    }

    public static boolean isNetworkConnected(Context context) {
        return (context = NetworkState.getActiveNetworkInfo(context)) != null && context.isConnected();
    }

    public static NetworkInfo getActiveNetworkInfo(Context networkInfoArray) {
        try {
            networkInfoArray = (ConnectivityManager)networkInfoArray.getSystemService("connectivity");
            if (networkInfoArray == null) {
                return null;
            }
            NetworkInfo networkInfo = networkInfoArray.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                return networkInfo;
            }
            if ((networkInfoArray = networkInfoArray.getAllNetworkInfo()) == null) {
                return null;
            }
            for (int i2 = 0; i2 < networkInfoArray.length; ++i2) {
                if (networkInfoArray[i2] == null || !networkInfoArray[i2].isConnected()) continue;
                networkInfo = networkInfoArray[i2];
                break;
            }
            return networkInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static class MyBroadcastReceiver
    extends BroadcastReceiver {
        WeakReference<NetworkChangeListener> reference = null;

        public MyBroadcastReceiver(NetworkChangeListener object) {
            this.reference = object = new WeakReference<NetworkChangeListener>((NetworkChangeListener)object);
        }

        public void onReceive(Context context, Intent intent) {
            if (this.reference != null && this.reference.get() != null) {
                ((NetworkChangeListener)this.reference.get()).networkStateChanged(context);
            }
        }
    }

    public static interface NetworkChangeListener {
        public void networkStateChanged(Context var1);
    }
}

