/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.GLTFOverlayOptions;
import com.amap.api.maps.model.LatLng;
import java.lang.ref.WeakReference;

public class GLTFOverlay
extends BaseOverlay {
    private GLTFOverlayOptions mOptions;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public GLTFOverlay(IGlOverlayLayer iGlOverlayLayer, GLTFOverlayOptions gLTFOverlayOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.mOptions = gLTFOverlayOptions;
    }

    public void remove() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public GLTFOverlayOptions getOptions() {
        return this.mOptions.clone();
    }

    public String getId() {
        try {
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setLatLng(LatLng latLng) {
        try {
            if (this.mOptions != null) {
                this.mOptions.latLng(latLng);
                this.a();
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public LatLng getLatlng() {
        if (this.mOptions != null) {
            return this.mOptions.getLatLng();
        }
        return null;
    }

    public void setDraggable(boolean bl2) {
        if (this.mOptions != null) {
            this.mOptions.setDraggable(bl2);
        }
    }

    public boolean isDraggable() {
        if (this.mOptions != null) {
            return this.mOptions.isDraggable();
        }
        return true;
    }

    public void setClickable(boolean bl2) {
        if (this.mOptions != null) {
            this.mOptions.setClickable(bl2);
        }
    }

    public boolean isClickable() {
        if (this.mOptions != null) {
            return this.mOptions.isClickable();
        }
        return false;
    }

    public void tapClick() {
        if (this.mOptions != null) {
            this.mOptions.tapClick();
        }
        try {
            this.a("tapClick");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean isInfoWindowShow() {
        if (this.mOptions != null) {
            return this.mOptions.isInfoWindowShow();
        }
        return false;
    }

    public void setInfoWindowView(BitmapDescriptor bitmapDescriptor) {
        if (this.mOptions != null) {
            this.mOptions.infoWindowView(bitmapDescriptor);
            this.a();
        }
    }

    public BitmapDescriptor getInfoWindowView() {
        if (this.mOptions != null) {
            return this.mOptions.getInfoWindowView();
        }
        return null;
    }

    public void setCurrentAnimationIndex(int n2) {
        if (this.mOptions != null) {
            this.mOptions.setCurrentAnimationIndex(n2);
            this.a();
        }
    }

    public int getCurrentAnimationIndex() {
        if (this.mOptions != null) {
            this.mOptions.getCurrentAnimationIndex();
        }
        return -1;
    }

    public boolean isAnimated() {
        Object object = this.a("isAnimated");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public void setZIndex(float f2) {
        if (this.mOptions != null) {
            this.mOptions.setZIndex(f2);
            this.a();
        }
    }

    public float getZIndex() {
        if (this.mOptions != null) {
            return this.mOptions.getZIndex();
        }
        return 0.0f;
    }

    private Object a(String string2) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                return iGlOverlayLayer.getNativeProperties(this.overlayName, string2, null);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.mOptions);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }
}

