/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import com.autonavi.base.amap.mapcore.ConvertString;
import java.io.ByteArrayOutputStream;

public class Convert {
    public static int getInt(byte[] byArray, int n2) {
        int n3 = byArray[3 + n2] & 0xFF;
        int n4 = byArray[2 + n2] & 0xFF;
        int n5 = byArray[1 + n2] & 0xFF;
        int n6 = byArray[0 + n2] & 0xFF;
        return (n3 << 24) + (n4 << 16) + (n5 << 8) + (n6 << 0);
    }

    public static short getShort(byte[] byArray, int n2) {
        int n3 = byArray[n2 + 1] & 0xFF;
        int n4 = byArray[n2 + 0] & 0xFF;
        return (short)((n3 << 8) + (n4 << 0));
    }

    public static int getUShort(byte[] byArray, int n2) {
        int n3 = byArray[n2 + 1] & 0xFF;
        int n4 = byArray[n2 + 0] & 0xFF;
        return (n3 << 8) + (n4 << 0);
    }

    public static boolean getBit(byte by2, int n2) {
        return by2 << 32 - n2 >>> 32 - n2 >>> n2 - 1 > 0;
    }

    public static byte[] copyString(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] covertBytes(byte by2) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = by2;
        return byArray2;
    }

    public static byte[] convertInt(int n2) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(n2 & 0xFF);
        byArray2[1] = (byte)(n2 >> 8 & 0xFF);
        byArray2[2] = (byte)(n2 >> 16 & 0xFF);
        byArray2[3] = (byte)(n2 >> 24 & 0xFF);
        return byArray2;
    }

    public static int getNum(byte by2, int n2, int n3) {
        return by2 << 32 - n3 - 1 >>> 32 - n3 - 1 >>> n2;
    }

    public static int getNum(short s2, int n2, int n3) {
        return s2 << 32 - n3 >>> 32 - n3 >>> n2 - 1;
    }

    public static byte[] convertShort(int n2) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(n2 & 0xFF);
        byArray2[1] = (byte)(n2 >> 8 & 0xFF);
        return byArray2;
    }

    public static void writeInt(byte[] byArray, int n2, int n3) {
        System.arraycopy(Convert.convertInt(n3), 0, byArray, n2, 4);
    }

    public static void writeShort(byte[] byArray, int n2, short s2) {
        System.arraycopy(Convert.convertShort(s2), 0, byArray, n2, 2);
    }

    public static void moveArray(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n2, byArray3, 0, n4);
        System.arraycopy(byArray3, 0, byArray2, n3, n4);
    }

    public static String getString(byte[] byArray, int n2, int n3) {
        try {
            return new String(byArray, n2, n3, "UTF-8");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static byte[] getSubBytes(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] get1BString(String object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object = ((String)object).getBytes("UTF-8");
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = (byte)((Object)object).length;
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write((byte[])object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[1];
        }
    }

    public static byte[] get2BString(String object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object = ((String)object).getBytes("UTF-8");
            byteArrayOutputStream.write(Convert.convertShort(((Object)object).length));
            byteArrayOutputStream.write((byte[])object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[1];
        }
    }

    public static double convertDouble(byte[] byArray, int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            l2 += (long)(byArray[i2 + n2] & 0xFF) << 8 * i2;
        }
        return Double.longBitsToDouble(l2);
    }

    public static byte[] getDouble(double d2) {
        byte[] byArray = new byte[8];
        String string2 = Long.toHexString(Double.doubleToLongBits(d2));
        for (int i2 = 0; i2 < 8; ++i2) {
            String string3 = string2.substring(2 * i2, 2 * i2 + 2);
            byArray[7 - i2] = (byte)Integer.parseInt(string3, 16);
        }
        return byArray;
    }

    public static void convert1bString(byte[] byArray, int n2, ConvertString convertString) {
        try {
            convertString.byteLength = byArray[n2];
            convertString.value = new String(byArray, n2 + 1, convertString.byteLength, "UTF-8");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            convertString.byteLength = 0;
            convertString.value = "";
            return;
        }
    }

    public static void convert2bString(byte[] byArray, int n2, ConvertString convertString) {
        try {
            convertString.byteLength = Convert.getShort(byArray, n2);
            convertString.value = new String(byArray, n2 + 2, convertString.byteLength, "UTF-8");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            convertString.byteLength = 0;
            convertString.value = "";
            return;
        }
    }

    public static final String bytesToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string2 = Integer.toHexString(0xFF & byArray[i2]);
            if (string2.length() < 2) {
                stringBuffer.append(0);
            }
            stringBuffer.append(string2.toUpperCase());
        }
        return stringBuffer.toString();
    }
}

