/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.GroundOverlayOptionsCreator;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;

@JBindingInclude
public final class GroundOverlayOptions
extends BaseOptions
implements Parcelable,
Cloneable {
    @JBindingExclude
    private static final String CLASSNAME = "GroundOverlayOptions";
    @JBindingExclude
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    @JBindingExclude
    public static final float NO_DIMENSION = -1.0f;
    @JBindingExclude
    private final int mVersionCode;
    private BitmapDescriptor bitmapDescriptor;
    private LatLng latLng;
    private float width;
    private float height;
    @JBindingExclude
    private LatLngBounds latlngBounds;
    private float bearing;
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    private float transparency = 0.0f;
    private float anchorU = 0.5f;
    private float anchorV = 0.5f;
    @JBindingExclude
    private final double NF_PI = 0.01745329251994329;
    @JBindingExclude
    private final double R = 6371000.79;
    private LatLng southwest;
    private LatLng northeast;

    @JBindingExclude
    GroundOverlayOptions(int n2, LatLng latLng, float f2, float f3, LatLngBounds latLngBounds, float f4, float f5, boolean bl2, float f6, float f7, float f8) {
        this.mVersionCode = n2;
        this.bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(null);
        this.latLng = latLng;
        this.width = f2;
        this.height = f3;
        this.latlngBounds = latLngBounds;
        this.bearing = f4;
        this.zIndex = f5;
        this.isVisible = bl2;
        this.transparency = f6;
        this.anchorU = f7;
        this.anchorV = f8;
        this.southwest = latLngBounds.southwest;
        this.northeast = latLngBounds.northeast;
        this.type = CLASSNAME;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
        this.type = CLASSNAME;
    }

    public final GroundOverlayOptions image(BitmapDescriptor bitmapDescriptor) {
        this.bitmapDescriptor = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f2, float f3) {
        this.anchorU = f2;
        this.anchorV = f3;
        if (this.latlngBounds != null) {
            this.a();
        } else if (this.latLng != null) {
            this.b();
        }
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f2) {
        if (this.latlngBounds != null) {
            Log.w((String)CLASSNAME, (String)"Position has already been set using positionFromBounds");
        }
        if (latLng == null) {
            Log.w((String)CLASSNAME, (String)"Location must be specified");
        }
        if (f2 <= 0.0f) {
            Log.w((String)CLASSNAME, (String)"Width must be non-negative");
        }
        float f3 = f2;
        return this.a(latLng, f3, f3);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f2, float f3) {
        if (this.latlngBounds != null) {
            Log.w((String)CLASSNAME, (String)"Position has already been set using positionFromBounds");
        }
        if (latLng == null) {
            Log.w((String)CLASSNAME, (String)"Location must be specified");
        }
        if (f2 <= 0.0f || f3 <= 0.0f) {
            Log.w((String)CLASSNAME, (String)"Width and Height must be non-negative");
        }
        return this.a(latLng, f2, f3);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.latLng = latLng;
        this.width = f2;
        this.height = f3;
        this.b();
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        this.latlngBounds = latLngBounds;
        this.southwest = latLngBounds.southwest;
        this.northeast = latLngBounds.northeast;
        this.a();
        return this;
    }

    public final GroundOverlayOptions bearing(float f2) {
        this.bearing = f2;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public final GroundOverlayOptions transparency(float f2) {
        if (f2 < 0.0f) {
            Log.w((String)CLASSNAME, (String)"Transparency must be in the range [0..1]");
            f2 = 0.0f;
        }
        this.transparency = f2;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.bitmapDescriptor;
    }

    public final LatLng getLocation() {
        return this.latLng;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final LatLngBounds getBounds() {
        return this.latlngBounds;
    }

    public final float getBearing() {
        return this.bearing;
    }

    public final float getZIndex() {
        return this.zIndex;
    }

    public final float getTransparency() {
        return this.transparency;
    }

    public final float getAnchorU() {
        return this.anchorU;
    }

    public final float getAnchorV() {
        return this.anchorV;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.mVersionCode);
        parcel.writeParcelable((Parcelable)this.bitmapDescriptor, n2);
        parcel.writeParcelable((Parcelable)this.latLng, n2);
        parcel.writeFloat(this.width);
        parcel.writeFloat(this.height);
        parcel.writeParcelable((Parcelable)this.latlngBounds, n2);
        parcel.writeFloat(this.bearing);
        parcel.writeFloat(this.zIndex);
        parcel.writeByte((byte)(this.isVisible ? 1 : 0));
        parcel.writeFloat(this.transparency);
        parcel.writeFloat(this.anchorU);
        parcel.writeFloat(this.anchorV);
    }

    private void a() {
        if (this.southwest == null || this.northeast == null) {
            return;
        }
        this.latLng = new LatLng(this.southwest.latitude + (double)(1.0f - this.anchorV) * (this.northeast.latitude - this.southwest.latitude), this.southwest.longitude + (double)this.anchorU * (this.northeast.longitude - this.southwest.longitude));
        this.width = (float)(6371000.79 * Math.cos(this.latLng.latitude * 0.01745329251994329) * (this.northeast.longitude - this.southwest.longitude) * 0.01745329251994329);
        this.height = (float)(6371000.79 * (this.northeast.latitude - this.southwest.latitude) * 0.01745329251994329);
    }

    private void b() {
        if (this.latLng == null) {
            return;
        }
        double d2 = (double)this.width / (6371000.79 * Math.cos(this.latLng.latitude * 0.01745329251994329) * 0.01745329251994329);
        double d3 = (double)this.height / 111194.94043265979;
        try {
            this.latlngBounds = new LatLngBounds(new LatLng(this.latLng.latitude - (double)(1.0f - this.anchorV) * d3, this.latLng.longitude - (double)this.anchorU * d2), new LatLng(this.latLng.latitude + (double)this.anchorV * d3, this.latLng.longitude + (double)(1.0f - this.anchorU) * d2));
            this.southwest = this.latlngBounds.southwest;
            this.northeast = this.latlngBounds.northeast;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final GroundOverlayOptions clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        GroundOverlayOptions groundOverlayOptions = new GroundOverlayOptions();
        new GroundOverlayOptions().bitmapDescriptor = this.bitmapDescriptor;
        groundOverlayOptions.latLng = this.latLng;
        groundOverlayOptions.width = this.width;
        groundOverlayOptions.height = this.height;
        groundOverlayOptions.latlngBounds = this.latlngBounds;
        groundOverlayOptions.bearing = this.bearing;
        groundOverlayOptions.zIndex = this.zIndex;
        groundOverlayOptions.isVisible = this.isVisible;
        groundOverlayOptions.transparency = this.transparency;
        groundOverlayOptions.anchorU = this.anchorU;
        groundOverlayOptions.anchorV = this.anchorV;
        groundOverlayOptions.southwest = this.southwest;
        groundOverlayOptions.northeast = this.northeast;
        return groundOverlayOptions;
    }
}

