/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.col.3sl.dy;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.CircleHoleOptions;
import com.amap.api.maps.model.CircleOptionsCreator;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolygonHoleOptions;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JBindingInclude
public final class CircleOptions
extends BaseOptions
implements Parcelable,
Cloneable {
    @JBindingExclude
    public static final CircleOptionsCreator CREATOR = new CircleOptionsCreator();
    @JBindingExclude
    String a;
    private LatLng point = null;
    private double radius = 0.0;
    private float strokeWidth = 10.0f;
    private int strokeColor = -16777216;
    private int fillColor = 0;
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    private List<BaseHoleOptions> holeOptions;
    private int dottedLineType = -1;
    private boolean isUsePolylineStroke = true;
    private CircleUpdateFlags updateFlags = new CircleUpdateFlags();

    public CircleOptions() {
        this.holeOptions = new ArrayList<BaseHoleOptions>();
        this.type = "CircleOptions";
    }

    public final void writeToParcel(Parcel parcel, int n2) {
        Bundle bundle = new Bundle();
        if (this.point != null) {
            bundle.putDouble("lat", this.point.latitude);
            bundle.putDouble("lng", this.point.longitude);
        }
        parcel.writeBundle(bundle);
        parcel.writeDouble(this.radius);
        parcel.writeFloat(this.strokeWidth);
        parcel.writeInt(this.strokeColor);
        parcel.writeInt(this.fillColor);
        parcel.writeFloat(this.zIndex);
        parcel.writeByte((byte)(this.isVisible ? 1 : 0));
        parcel.writeString(this.a);
        parcel.writeList(this.holeOptions);
        parcel.writeInt(this.dottedLineType);
        parcel.writeByte((byte)(this.isUsePolylineStroke ? 1 : 0));
    }

    public final int describeContents() {
        return 0;
    }

    public final CircleOptions center(LatLng latLng) {
        this.point = latLng;
        this.updateFlags.isCenterUpdated = true;
        this.a();
        return this;
    }

    public final CircleOptions radius(double d2) {
        this.radius = d2;
        this.updateFlags.isRadiusUpdated = true;
        this.a();
        return this;
    }

    public final CircleOptions strokeWidth(float f2) {
        this.strokeWidth = f2;
        return this;
    }

    public final CircleOptions strokeColor(int n2) {
        this.strokeColor = n2;
        return this;
    }

    public final CircleOptions fillColor(int n2) {
        this.fillColor = n2;
        return this;
    }

    public final CircleOptions zIndex(float f2) {
        if (this.zIndex != f2) {
            this.updateFlags.zIndexUpdate = true;
        }
        this.zIndex = f2;
        return this;
    }

    public final CircleOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public final LatLng getCenter() {
        return this.point;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final int getStrokeColor() {
        return this.strokeColor;
    }

    public final int getFillColor() {
        return this.fillColor;
    }

    public final float getZIndex() {
        return this.zIndex;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final CircleOptions addHoles(BaseHoleOptions ... baseHoleOptionsArray) {
        try {
            if (baseHoleOptionsArray != null) {
                this.holeOptions.addAll(Arrays.asList(baseHoleOptionsArray));
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public final CircleOptions addHoles(Iterable<BaseHoleOptions> object) {
        try {
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    BaseHoleOptions baseHoleOptions = (BaseHoleOptions)object.next();
                    this.holeOptions.add(baseHoleOptions);
                }
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public final List<BaseHoleOptions> getHoleOptions() {
        return this.holeOptions;
    }

    public final CircleOptions setStrokeDottedLineType(int n2) {
        this.dottedLineType = n2;
        return this;
    }

    public final int getStrokeDottedLineType() {
        return this.dottedLineType;
    }

    public final CircleOptions usePolylineStroke(boolean bl2) {
        this.isUsePolylineStroke = bl2;
        return this;
    }

    public final boolean isUsePolylineStroke() {
        return this.isUsePolylineStroke;
    }

    private void a() {
        if (this.holeOptions != null) {
            ArrayList<BaseHoleOptions> arrayList = new ArrayList<BaseHoleOptions>();
            List<BaseHoleOptions> list = this.holeOptions;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                BaseHoleOptions baseHoleOptions = list.get(i2);
                if (baseHoleOptions instanceof PolygonHoleOptions) {
                    baseHoleOptions = (PolygonHoleOptions)baseHoleOptions;
                    if (!dy.a(this.getRadius(), this.getCenter(), arrayList, (PolygonHoleOptions)baseHoleOptions) || dy.a(arrayList, (PolygonHoleOptions)baseHoleOptions)) continue;
                    arrayList.add(baseHoleOptions);
                    continue;
                }
                if (!(baseHoleOptions instanceof CircleHoleOptions)) continue;
                baseHoleOptions = (CircleHoleOptions)baseHoleOptions;
                if (!dy.a(this.getRadius(), this.getCenter(), (CircleHoleOptions)baseHoleOptions) || dy.a(arrayList, (CircleHoleOptions)baseHoleOptions)) continue;
                arrayList.add(baseHoleOptions);
            }
            this.holeOptions.clear();
            this.holeOptions.addAll(arrayList);
            this.updateFlags.isHoleOptionsUpdated = true;
        }
    }

    public final CircleOptions clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        CircleOptions circleOptions = new CircleOptions();
        new CircleOptions().a = this.a;
        circleOptions.point = this.point;
        circleOptions.radius = this.radius;
        circleOptions.strokeWidth = this.strokeWidth;
        circleOptions.strokeColor = this.strokeColor;
        circleOptions.fillColor = this.fillColor;
        circleOptions.zIndex = this.zIndex;
        circleOptions.isVisible = this.isVisible;
        circleOptions.holeOptions = this.holeOptions;
        circleOptions.dottedLineType = this.dottedLineType;
        circleOptions.isUsePolylineStroke = this.isUsePolylineStroke;
        circleOptions.updateFlags = this.updateFlags;
        return circleOptions;
    }

    @Override
    public final void resetUpdateFlags() {
        this.updateFlags.reset();
    }

    @Override
    protected final CircleUpdateFlags getUpdateFlags() {
        return this.updateFlags;
    }

    @JBindingInclude
    protected static class CircleUpdateFlags
    extends BaseOptions.BaseUpdateFlags {
        protected boolean isCenterUpdated = false;
        protected boolean isRadiusUpdated = false;
        protected boolean isHoleOptionsUpdated = false;

        protected CircleUpdateFlags() {
        }

        @Override
        public void reset() {
            super.reset();
            this.isCenterUpdated = false;
            this.isRadiusUpdated = false;
            this.isHoleOptionsUpdated = false;
        }
    }
}

