/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap;

import android.content.Context;
import com.amap.api.col.3sl.dw;
import com.amap.api.col.3sl.dy;
import com.amap.api.col.3sl.js;
import com.amap.api.col.3sl.lz;
import com.amap.api.maps.MapsInitializer;
import com.autonavi.amap.mapcore.tools.GlMapUtil;
import com.autonavi.base.ae.gmap.GLMapEngine;
import com.autonavi.base.ae.gmap.NetworkProxy;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import com.autonavi.base.amap.mapcore.maploader.AMapLoader;
import com.autonavi.base.amap.mapcore.maploader.NetworkState;
import com.autonavi.base.amap.mapcore.tools.GLConvertUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@JBindingInclude
public class NetworkProxyManager {
    private static NetworkProxyManager sInstance;
    private Context context;
    private boolean isNetworkConnected = false;
    private Map<Long, AMapLoader> aMapLoaderHashtable = new ConcurrentHashMap<Long, AMapLoader>();
    private Map<Long, GLMapEngine> engines = new ConcurrentHashMap<Long, GLMapEngine>();
    private NetworkState networkState;
    private NetworkProxy networkProxy;
    private String userAgent;
    private NetworkState.NetworkChangeListener networkChangeListener = new NetworkState.NetworkChangeListener(){

        @Override
        public void networkStateChanged(Context object) {
            NetworkProxyManager.this.isNetworkConnected = NetworkState.isNetworkConnected((Context)object);
            object = NetworkProxyManager.this.engines.entrySet().iterator();
            while (object.hasNext()) {
                ((GLMapEngine)((Map.Entry)object.next()).getValue()).setNetStatus(NetworkProxyManager.this.isNetworkConnected);
            }
        }
    };

    public static NetworkProxyManager getInstance() {
        if (sInstance == null) {
            sInstance = new NetworkProxyManager();
        }
        return sInstance;
    }

    private NetworkProxyManager() {
    }

    public void init() {
        this.networkProxy = this.createNetworkProxy();
        NetworkProxyManager networkProxyManager = this;
        networkProxyManager.initNetworkProxy(networkProxyManager.networkProxy);
        this.initNetworkState();
    }

    public boolean isReady() {
        return this.context != null && this.networkProxy != null && this.networkState != null;
    }

    public void destroy() {
        if (this.networkProxy != null) {
            NetworkProxyManager networkProxyManager = this;
            networkProxyManager.destroyNetworkProxy(networkProxyManager.networkProxy);
            this.networkProxy = null;
        }
        this.releaseNetworkState();
        this.context = null;
    }

    public void initContext(Context context) {
        if (context == null) {
            return;
        }
        this.context = context.getApplicationContext();
    }

    public NetworkProxy createNetworkProxy() {
        long l2 = NetworkProxyManager.nativeCreateNetworkProxy(this);
        return new NetworkProxy(l2);
    }

    public void initNetworkProxy(NetworkProxy networkProxy) {
        NetworkProxyManager.nativeInitNetworkProxy(networkProxy.networkProxyInstance);
    }

    public void destroyNetworkProxy(NetworkProxy networkProxy) {
        NetworkProxyManager.nativeDestroyNetworkProxy(networkProxy.networkProxyInstance);
    }

    public boolean isNetworkConnected() {
        return this.isNetworkConnected;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    private void initNetworkState() {
        this.userAgent = System.getProperty("http.agent") + " amap/" + GlMapUtil.getAppVersionName(this.context);
        this.networkState = new NetworkState();
        this.networkState.setNetworkListener(this.networkChangeListener);
        this.networkState.registerNetChangeReceiver(this.context.getApplicationContext(), true);
        this.isNetworkConnected = NetworkState.isNetworkConnected(this.context.getApplicationContext());
    }

    private void releaseNetworkState() {
        if (this.networkState != null) {
            this.networkState.registerNetChangeReceiver(this.context.getApplicationContext(), false);
            this.networkState.setNetworkListener(null);
            this.networkState = null;
        }
    }

    public void notifyMapEngineCreated(long l2, GLMapEngine gLMapEngine) {
        this.engines.put(l2, gLMapEngine);
    }

    private synchronized void cancelAllAMapDownload() {
        try {
            Iterator iterator = new ConcurrentHashMap<Long, AMapLoader>(this.aMapLoaderHashtable).entrySet().iterator();
            while (iterator.hasNext()) {
                ((AMapLoader)iterator.next().getValue()).doCancelAndNotify();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void notifyMapEngineDestroyed(long l2) {
        this.engines.remove(l2);
        this.cancelAllAMapDownload();
    }

    @JBindingInclude
    public synchronized int requireMapDataAsyn(int n2, byte[] object) {
        if (object != null) {
            Object object2 = new AMapLoader.ADataRequestParam();
            int n3 = GLConvertUtil.getInt(object, 0);
            ((AMapLoader.ADataRequestParam)object2).requestBaseUrl = GLConvertUtil.getString(object, 4, n3);
            int n4 = 4 + n3;
            n3 = GLConvertUtil.getInt(object, n4);
            ((AMapLoader.ADataRequestParam)object2).requestUrl = GLConvertUtil.getSubBytes(object, n4 += 4, n3);
            n4 += n3;
            n3 = GLConvertUtil.getInt(object, n4);
            String string2 = GLConvertUtil.getString(object, n4 += 4, n3);
            ((AMapLoader.ADataRequestParam)object2).headers = dy.a(string2, "=>");
            n4 += n3;
            n3 = GLConvertUtil.getInt(object, n4);
            string2 = GLConvertUtil.getString(object, n4 += 4, n3);
            ((AMapLoader.ADataRequestParam)object2).queries = dy.a(string2, "=>");
            n4 += n3;
            n3 = GLConvertUtil.getInt(object, n4);
            string2 = GLConvertUtil.getString(object, n4 += 4, n3);
            ((AMapLoader.ADataRequestParam)object2).signs = dy.b(string2);
            ((AMapLoader.ADataRequestParam)object2).handler = GLConvertUtil.getLong(object, n4 += n3);
            n3 = GLConvertUtil.getInt(object, n4 += 8);
            ((AMapLoader.ADataRequestParam)object2).enCodeString = GLConvertUtil.getSubBytes(object, n4 += 4, n3);
            ((AMapLoader.ADataRequestParam)object2).nRequestType = GLConvertUtil.getInt(object, n4 += n3);
            ((AMapLoader.ADataRequestParam)object2).nCompress = GLConvertUtil.getInt(object, n4 += 4);
            ((AMapLoader.ADataRequestParam)object2).bodyType = GLConvertUtil.getInt(object, n4 += 4);
            object = new AMapLoader(this.context, (AMapLoader.ADataRequestParam)object2);
            this.aMapLoaderHashtable.put(((AMapLoader.ADataRequestParam)object2).handler, (AMapLoader)object);
            try {
                dw.a().a(new lz((AMapLoader)object){
                    final /* synthetic */ AMapLoader val$mapLoader;
                    {
                        this.val$mapLoader = aMapLoader;
                    }

                    @Override
                    public void runTask() {
                        try {
                            this.val$mapLoader.doRequest();
                            return;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            js.c(throwable, "download Thread", "AMapLoader doRequest");
                            dy.a(throwable2);
                            return;
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                object2 = throwable;
                js.c(throwable, "download Thread", "requireMapData");
                dy.a((Throwable)object2);
            }
        }
        return 0;
    }

    public synchronized void receiveNetData(long l2, byte[] byArray, int n2) {
        if (!this.aMapLoaderHashtable.containsKey(l2)) {
            return;
        }
        NetworkProxyManager.nativeReceiveNetData(byArray, l2, n2);
    }

    public synchronized void finishDownLoad(long l2) {
        if (!this.aMapLoaderHashtable.containsKey(l2)) {
            return;
        }
        NetworkProxyManager.nativeFinishDownLoad(l2);
        this.aMapLoaderHashtable.remove(l2);
    }

    public synchronized void netStop(long l2, int n2) {
        if (!this.aMapLoaderHashtable.containsKey(l2)) {
            return;
        }
        NetworkProxyManager.nativeFailedDownLoad(l2, -1);
        this.aMapLoaderHashtable.remove(l2);
    }

    public synchronized void netCancel(long l2, int n2) {
        if (!this.aMapLoaderHashtable.containsKey(l2)) {
            return;
        }
        NetworkProxyManager.nativeFailedDownLoad(l2, -1);
        this.aMapLoaderHashtable.remove(l2);
    }

    public synchronized void netError(long l2, int n2, int n3) {
        if (!this.aMapLoaderHashtable.containsKey(l2)) {
            return;
        }
        NetworkProxyManager.nativeFailedDownLoad(l2, n3);
        this.aMapLoaderHashtable.remove(l2);
        try {
            if (MapsInitializer.getExceptionLogger() != null) {
                MapsInitializer.getExceptionLogger().onDownloaderException(n2, n3);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private static native long nativeCreateNetworkProxy(Object var0);

    private static native void nativeInitNetworkProxy(long var0);

    private static native void nativeDestroyNetworkProxy(long var0);

    private static native void nativeReceiveNetData(byte[] var0, long var1, int var3);

    private static native void nativeFinishDownLoad(long var0);

    private static native void nativeCancelDownLoad(long var0);

    private static native void nativeFailedDownLoad(long var0, int var2);
}

