/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.amap.api.col.3sl.dr;
import com.amap.api.col.3sl.dy;
import com.amap.api.col.3sl.js;
import com.amap.api.maps.model.CameraPositionCreator;
import com.amap.api.maps.model.LatLng;

public final class CameraPosition
implements Parcelable {
    private static final String CLASSNAME = "CameraPosition";
    public static final CameraPositionCreator CREATOR = new CameraPositionCreator();
    public final LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;
    public final boolean isAbroad;

    public CameraPosition(LatLng latLng, float f2, float f3, float f4) {
        if (latLng == null) {
            Log.w((String)CLASSNAME, (String)"\u6784\u5efaCameraPosition\u65f6,\u4f4d\u7f6e(target)\u4e0d\u80fd\u4e3anull");
        }
        this.target = latLng;
        this.zoom = f2;
        this.tilt = f3;
        this.bearing = ((double)f4 <= 0.0 ? f4 % 360.0f + 360.0f : f4) % 360.0f;
        if (latLng != null) {
            this.isAbroad = !dr.a(latLng.latitude, latLng.longitude);
            return;
        }
        this.isAbroad = false;
    }

    public final void writeToParcel(Parcel parcel, int n2) {
        parcel.writeFloat(this.bearing);
        parcel.writeFloat((float)this.target.latitude);
        parcel.writeFloat((float)this.target.longitude);
        parcel.writeFloat(this.tilt);
        parcel.writeFloat(this.zoom);
    }

    public final int describeContents() {
        return 0;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static final CameraPosition fromLatLngZoom(LatLng latLng, float f2) {
        return new CameraPosition(latLng, f2, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition cameraPosition) {
        return new Builder(cameraPosition);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CameraPosition)) {
            return false;
        }
        object = (CameraPosition)object;
        return this.target.equals(((CameraPosition)object).target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(((CameraPosition)object).zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(((CameraPosition)object).tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(((CameraPosition)object).bearing);
    }

    public final String toString() {
        return dy.a(dy.a("target", (Object)this.target), dy.a("zoom", Float.valueOf(this.zoom)), dy.a("tilt", Float.valueOf(this.tilt)), dy.a("bearing", Float.valueOf(this.bearing)));
    }

    public static final class Builder {
        private LatLng target;
        private float zoom;
        private float tilt;
        private float bearing;

        public Builder() {
        }

        public Builder(CameraPosition cameraPosition) {
            this.target(cameraPosition.target).bearing(cameraPosition.bearing).tilt(cameraPosition.tilt).zoom(cameraPosition.zoom);
        }

        public final Builder target(LatLng latLng) {
            this.target = latLng;
            return this;
        }

        public final Builder zoom(float f2) {
            this.zoom = f2;
            return this;
        }

        public final Builder tilt(float f2) {
            this.tilt = f2;
            return this;
        }

        public final Builder bearing(float f2) {
            this.bearing = f2;
            return this;
        }

        public final CameraPosition build() {
            String string2 = "build";
            try {
                if (this.target == null) {
                    Log.w((String)CameraPosition.CLASSNAME, (String)"target is null");
                    return null;
                }
                return new CameraPosition(this.target, this.zoom, this.tilt, this.bearing);
            }
            catch (Throwable throwable) {
                js.c(throwable, CameraPosition.CLASSNAME, string2);
                return null;
            }
        }
    }
}

